/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.utils.mapui;

import filenet.vw.api.VWMapNode;
import filenet.vw.api.VWRouteDefinition;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.utils.images.VWImageLoader;
import filenet.vw.toolkit.utils.mapui.IVWRouteRender;
import filenet.vw.toolkit.utils.mapui.IVWSelectWorkflowItem;
import filenet.vw.toolkit.utils.mapui.VWBaseAssociationUI;
import filenet.vw.toolkit.utils.mapui.VWBaseStepUI;
import filenet.vw.toolkit.utils.mapui.VWBaseTextAnnotationUI;
import filenet.vw.toolkit.utils.mapui.VWImageAttrUI;
import filenet.vw.toolkit.utils.mapui.VWLabelUI;
import filenet.vw.toolkit.utils.mapui.VWMapAttribs;
import filenet.vw.toolkit.utils.mapui.VWRouteArcRender;
import filenet.vw.toolkit.utils.mapui.VWRouteLineRender;
import filenet.vw.toolkit.utils.mapui.VWStepRouteColors;
import filenet.vw.toolkit.utils.mapui.VWTextAttrUI;
import filenet.vw.toolkit.utils.wfdefinition.IVWRouteDefinitionContainer;
import java.awt.AWTEventMulticaster;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.print.PageFormat;
import java.awt.print.PrinterException;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.swing.ImageIcon;
import javax.swing.JComponent;

public class VWBaseRouteUI
extends JComponent
implements IVWSelectWorkflowItem,
IVWRouteDefinitionContainer {
    public static final int STRAIGHT = 1;
    public static final int ARC = 2;
    protected static Image s_conditionImage = null;
    private static int s_conditionImageLoc = 50;
    private static int s_artificialNamePixelWidth = 150;
    private static int s_artificialNamePixelHeight = 30;
    private static int s_maxDisplayName = 20;
    private static int s_attributesSpace = 2;
    protected VWRouteDefinition m_routeDefinition = null;
    protected VWStepRouteColors m_stepRouteColors = null;
    protected boolean m_bFocus = false;
    protected boolean m_bSelect = false;
    protected IVWRouteRender m_render = null;
    protected VWBaseStepUI m_srcStep = null;
    protected VWBaseStepUI m_destStep = null;
    protected FocusListener m_focusListeners = null;
    protected VWLabelUI m_label = null;
    protected VWMapAttribs m_mapAttribs = null;
    private Hashtable m_associations = new Hashtable();

    public VWBaseRouteUI(VWRouteDefinition routeDefinition, VWBaseStepUI srcStep, VWBaseStepUI destStep, boolean bFocus, int lineType, VWStepRouteColors stepRouteColors, VWMapAttribs mapAttribs) {
        ImageIcon imageIcon;
        if (s_conditionImage == null && (imageIcon = VWImageLoader.createImageIcon("routecondition.gif")) != null) {
            s_conditionImage = imageIcon.getImage();
        }
        VWDebug.nullCheck(routeDefinition);
        this.m_routeDefinition = routeDefinition;
        this.m_srcStep = srcStep;
        this.m_destStep = destStep;
        this.m_stepRouteColors = stepRouteColors;
        this.setFocus(bFocus);
        this.m_render = lineType == 1 ? new VWRouteLineRender(this) : new VWRouteArcRender(this);
        this.m_render.calcCoords();
        this.m_label = new VWLabelUI();
        this.m_mapAttribs = mapAttribs;
    }

    public VWRouteDefinition getRouteDefinition() {
        return this.m_routeDefinition;
    }

    public void setLineType(int lineType) {
        this.m_render = lineType == 1 ? new VWRouteLineRender(this) : new VWRouteArcRender(this);
    }

    public int getLineType() {
        if (this.m_render instanceof VWRouteLineRender) {
            return 1;
        }
        return 2;
    }

    public boolean captureFocus(Point loc) {
        this.setFocus(this.m_render.contains(loc));
        return this.getFocus();
    }

    public synchronized void addFocusListener(FocusListener l) {
        this.m_focusListeners = AWTEventMulticaster.add(this.m_focusListeners, l);
    }

    public synchronized void removeFocusListener(FocusListener l) {
        this.m_focusListeners = AWTEventMulticaster.remove(this.m_focusListeners, l);
    }

    public boolean getFocus() {
        return this.m_bFocus;
    }

    public void setFocus(boolean bFocus) {
        if (this.m_bFocus != bFocus) {
            this.m_bFocus = bFocus;
            if (this.m_bFocus) {
                this.setSelect(true);
            }
            if (this.m_focusListeners != null) {
                if (this.m_bFocus) {
                    this.m_focusListeners.focusGained(new FocusEvent(this, 1004));
                } else {
                    this.m_focusListeners.focusLost(new FocusEvent(this, 1005));
                }
            }
        }
    }

    public boolean getSelect() {
        return this.m_bSelect;
    }

    public void setSelect(boolean bSelect) {
        if (this.m_bSelect != bSelect) {
            this.m_bSelect = bSelect;
            if (!bSelect) {
                this.setFocus(false);
            }
        }
    }

    public boolean contains(Point loc) {
        return this.m_render.contains(loc);
    }

    public Enumeration getAssociations() {
        if (this.m_associations == null) {
            this.m_associations = new Hashtable();
        }
        return this.m_associations.keys();
    }

    public void addAssociation(VWBaseAssociationUI association, VWBaseTextAnnotationUI textAnnotation) {
        if (!this.m_associations.containsKey(association)) {
            this.m_associations.put(association, textAnnotation);
        } else {
            VWDebug.logError("The association already exists.");
        }
    }

    public void removeAssociation(VWBaseAssociationUI association) {
        if (this.m_associations.remove(association) == null) {
            VWDebug.logError("The association does not exist. Cannot remove.");
        }
    }

    public Rectangle getBounds() {
        Rectangle rect = this.m_render.getBounds();
        Point pt = this.getConditionImagePt();
        if (pt != null) {
            rect = rect.union(new Rectangle(pt.x, pt.y, s_conditionImage.getWidth(this) + 1, s_conditionImage.getHeight(this) + 1));
        }
        if ((pt = this.getNamePt()) != null) {
            Rectangle nameRect = new Rectangle(pt.x - s_artificialNamePixelWidth / 2, pt.y - s_artificialNamePixelHeight / 2, s_artificialNamePixelWidth, s_artificialNamePixelHeight);
            rect = rect.union(nameRect);
        }
        return rect;
    }

    public void recalcPosition() {
        this.m_render.calcCoords();
    }

    public void paintComponent(Graphics g) {
        try {
            this.m_render.calcCoords();
            this.m_render.paintComponent(g);
            this.createLabel();
            this.m_label.paintComponent(g, this.getCenterPoint(), true);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void printComponent(Graphics2D g2, PageFormat pf, int pi, int wp, int hp) throws PrinterException {
        int row = pi / wp;
        int col = pi % wp;
        double iW = pf.getImageableWidth();
        double iH = pf.getImageableHeight();
        int pageX = (int)Math.round((double)col * iW);
        int pageY = (int)Math.round((double)row * iH);
        int pageX2 = pageX + (int)iW;
        int pageY2 = pageY + (int)iH;
        this.m_render.printComponent(g2, pageX, pageY);
        this.createLabel();
        this.m_label.printComponent(g2, this.getCenterPoint(), pageX, pageY, pageX2, pageY2, true);
    }

    public void printProperty(Graphics g, PageFormat pf) throws PrinterException {
    }

    private Point getNamePt() {
        Point pt = null;
        if (this.m_routeDefinition != null && this.m_routeDefinition.getName() != null) {
            pt = this.m_render.getCenterPoint();
        }
        return pt;
    }

    protected Point getCenterPoint() {
        Point pt = null;
        if (this.m_routeDefinition != null) {
            pt = this.m_render.getCenterPoint();
        }
        return pt;
    }

    private Point getConditionImagePt() {
        Point pt = null;
        if (this.m_routeDefinition != null && this.m_routeDefinition.getCondition() != null && (pt = this.m_render instanceof VWRouteArcRender ? this.m_render.getPoint((double)s_conditionImageLoc * 1.25) : this.m_render.getPoint(s_conditionImageLoc)) != null) {
            pt.y -= 5 + s_conditionImage.getHeight(this);
        }
        return pt;
    }

    private int getRouteCondition() {
        int routeOrder;
        block3: {
            routeOrder = 0;
            try {
                VWRouteDefinition[] routeDefs;
                VWMapNode mapNode = this.m_srcStep.getMapNode();
                if (mapNode == null || mapNode.getSplitType() != 2 || (routeDefs = mapNode.getNextRoutes()).length <= 1) break block3;
                int routeID = this.m_routeDefinition.getRouteId();
                for (int i = 0; i < routeDefs.length; ++i) {
                    if (routeID != routeDefs[i].getRouteId()) continue;
                    routeOrder = i + 1;
                    break;
                }
            }
            catch (Exception ex) {
                VWDebug.logException(ex);
            }
        }
        return routeOrder;
    }

    protected void createLabel() {
        boolean routeNum = false;
        int order = 0;
        String label = null;
        try {
            this.m_label.removeAllAttributes();
            if (this.m_mapAttribs.isConditionAttrsVisible()) {
                if (this.m_routeDefinition.getCondition() != null) {
                    this.m_label.addAttribute(new VWImageAttrUI(s_conditionImage));
                }
                if ((order = this.getRouteCondition()) != 0) {
                    routeNum = true;
                }
            }
            if (this.m_mapAttribs.isRouteNameVisible()) {
                label = this.m_routeDefinition.getName();
            }
            if (label != null) {
                if (routeNum) {
                    label = "[" + order + "] " + label;
                }
                if (label.length() > s_maxDisplayName) {
                    label = label.substring(0, s_maxDisplayName - 1);
                }
            } else if (routeNum) {
                label = new String("[" + order + "]");
            }
            if (label != null && label.length() > 0) {
                this.m_label.addAttribute(new VWTextAttrUI(label));
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public VWBaseStepUI getDestStep() {
        return this.m_destStep;
    }

    public VWBaseStepUI getSrcStep() {
        return this.m_srcStep;
    }

    public VWStepRouteColors getStepRouteColors() {
        return this.m_stepRouteColors;
    }

    public void replaceSrcStep(VWBaseStepUI newSrcStep) {
        this.m_srcStep = newSrcStep;
    }

    public void replaceDestStep(VWBaseStepUI newDestStep) {
        this.m_destStep = newDestStep;
    }

    public void removeReferences() {
        this.m_routeDefinition = null;
        this.m_stepRouteColors = null;
        this.m_srcStep = null;
        this.m_destStep = null;
        this.m_focusListeners = null;
        this.m_label = null;
        if (this.m_associations != null) {
            this.m_associations.clear();
            this.m_associations = null;
        }
    }
}

